#ifndef LIBWCCL_OPS_LOGICALPREDICATE_H
#define LIBWCCL_OPS_LOGICALPREDICATE_H

#include <vector>
#include <boost/shared_array.hpp>
#include <boost/assert.hpp>
#include <libcorpus2/tagset.h>

#include <libwccl/ops/predicate.h>

namespace Wccl {
/**
 * Abstract base class for predicates which are logical functions
 * (over any number of arguments)
 */
class LogicalPredicate : public Predicate {
public:
	typedef boost::shared_ptr<Function<Bool> > BoolFunctionPtr;
	typedef std::vector<BoolFunctionPtr> BoolFunctionPtrVector;

	LogicalPredicate(const boost::shared_ptr<BoolFunctionPtrVector>& expressions)
		: expressions_(expressions)
	{
		BOOST_ASSERT(expressions_);
		BOOST_ASSERT(expressions_->size() > 0);
	}

	/**
	 * String representation of the logical predicate, realised by default
	 * as "operator_name(expr1_string, ..., exprn_string)"
	 */
	virtual std::string to_string(const Corpus2::Tagset& tagset) const;

	/**
	 * String representation of the logical predicate, realised by default
	 * as "raw_operator_name(raw_expr1_string, ..., raw_exprn_string)"
	 * (this version doesn't require tagset, but may be incomplete and/or
	 * contain internal info)
	 */
	virtual std::string to_raw_string() const;

protected:
	const boost::shared_ptr<BoolFunctionPtrVector> expressions_;
};

} /* end ns Wccl */

#endif // LIBWCCL_OPS_LOGICALPREDICATE_H
