#ifndef LIBWCCL_OPS_FORMATTERS_H
#define LIBWCCL_OPS_FORMATTERS_H

#include <boost/shared_ptr.hpp>

#include <libcorpus2/tagset.h>

#include <libwccl/ops/functions.h>

namespace Wccl {

/**
 * Class that formats unary functions as string
 */
struct UnaryFunctionFormatter
{
    /** 
	 * String representation of an unary function.
	 * It is in form of
     * operator_name(argument_expression_string)
     * although the open and close brackets can be changed
     * (some operators use [])
     */
	static std::string to_string(
		const Corpus2::Tagset& tagset,
		const FunctionBase& f,
		const FunctionBase& arg_expr,
		const char* open_bracket = "(",
		const char* close_bracket = ")");

    /** 
	 * Raw string representation of an unary function.
	 * Does not require tagset, may contain internal info
	 * and/or be incomplete. It is in form of
     * raw_operator_name(raw_argument_expression_string)
     * although the open and close brackets can be changed
     * (some operators use [])
     */
	static std::string to_raw_string(
		const FunctionBase& f,
		const FunctionBase& arg_expr,
		const char* open_bracket = "(",
		const char* close_bracket = ")");
};

/**
 * Class that formats binary functions as string
 */
struct BinaryFunctionFormatter
{
    /** 
	 * String representation of a binary function.
	 * It is in form of
     * operator_name(arg1_expr_string, arg2_expr_string)
     */
	static std::string to_string(
		const Corpus2::Tagset& tagset,
		const FunctionBase& f,
		const FunctionBase& arg1_expr,
		const FunctionBase& arg2_expr);

    /** 
	 * Raw string representation of a binary function.
	 * Does not require tagset, may contain internal info
	 * and/or be incomplete. It is in form of
     * raw_op_name(raw_arg1_expr_string, raw_arg2_expr_string)
     */
	static std::string to_raw_string(
		const FunctionBase& f,
		const FunctionBase& arg1_expr,
		const FunctionBase& arg2_expr);
};

} /* end ns Wccl */


#endif // LIBWCCL_OPS_FORMATTERS_H
