#ifndef LIBWCCL_OPS_CONSTANT_H
#define LIBWCCL_OPS_CONSTANT_H

#include <boost/scoped_ptr.hpp>
#include <boost/concept_check.hpp>

#include <libwccl/ops/functions.h>

namespace Wccl {


/**
 * Functional realisation of constant value of a given type
 */
template<class TRet>
class Constant : public Function<TRet> {
	BOOST_CONCEPT_ASSERT((boost::CopyConstructible<TRet>));	
public:
	/*
	 * Constant function holds specific value to return when applying it
	 */
	Constant(const TRet& value)
		: value_(new TRet(value))
	{
		BOOST_ASSERT(value_);
	}
	
	/**
	 * Operator name for constant is string representation of its value
	 */
	virtual const std::string operator_name(const Corpus2::Tagset& tagset) const {
		return value_->to_string(tagset);
	}

	/**
	 * Operator name for constant is string representation of its value,
	 * tagset-independent in this case
	 */
	virtual const std::string raw_operator_name() const {
		return value_->to_raw_string();
	}

protected :
	typedef FunctionBase::BaseRetValPtr BaseRetValPtr ;

	/**
	 * Applying Constant function returns the held value of a constant
	 */
	virtual BaseRetValPtr  apply_internal(const SentenceContext&) const {
		return BaseRetValPtr (new TRet(*value_));
	}

private:
	const boost::scoped_ptr<const TRet> value_;
};


} /* end ns Wccl */

#endif // LIBWCCL_OPS_CONSTANT_H
