#ifndef LIBWCCL_OPS_AND_H
#define LIBWCCL_OPS_AND_H

#include <boost/foreach.hpp>
#define foreach         BOOST_FOREACH

#include <libwccl/ops/logicalpredicate.h>

namespace Wccl {

/**
 * Operator that realises "and" logical predicate
 */
class And : public LogicalPredicate
{
public:
	And(const boost::shared_ptr<BoolFunctionPtrVector>& expressions)
		: LogicalPredicate(expressions)
	{
	}

protected :
	typedef FunctionBase::BaseRetValPtr BaseRetValPtr ;

	/**
	 * "And" predicate evaluates each expression from left to right,
     * and returns False once an expression evaluating to False is found.
     * If all expressions were True, it returns True.
	 */
	virtual BaseRetValPtr apply_internal(const SentenceContext&) const;

	virtual const std::string raw_operator_name() const;
};

} /* end ns Wccl */
#endif // LIBWCCL_OPS_AND_H
