#include <libwccl/ops/tagrule.h>
#include <sstream>

namespace Wccl {

Bool TagRule::execute(SentenceContext &sentence_context)
{
	if(sentence_context.size() == 0) {
		throw InvalidArgument(
				"sentence_context",
				"Received an empty sentence.");
	}
	if(!sentence_context.is_current_inside()) {
		throw InvalidArgument(
				"sentence_context",
				"Current position is outside boundaries of the sentence.");
	}
	Bool changed(false);
	ActionExecContext aec(sentence_context, variables_);
	if(condition_->apply(aec)->get_value()) {
		foreach(const boost::shared_ptr<TagAction>& action, *actions_) {
			if(action->execute(aec).get_value()) {
				changed.set_value(true);
			}
		}
	}
	return changed;
}

const boost::shared_ptr<const Function<Bool> > TagRule::TrueCondition()
{
	static boost::shared_ptr<const Function<Bool> > true_constant(
			new Constant<Bool>(Bool(true)));
	return true_constant;
}


std::string TagRule::to_string(const Corpus2::Tagset &tagset) const
{
	std::ostringstream os;
	os << "rule(\"" << name_ << "\", " << condition_->to_string(tagset);
	foreach(const boost::shared_ptr<TagAction>& action, *actions_) {
		os << ", " << action->to_string(tagset);
	}
	os << ")";
	return os.str();
}

std::ostream& TagRule::write_to(std::ostream& os) const {
	os << "rule(\"" << name_ << "\", " << *condition_;
	foreach(const boost::shared_ptr<TagAction>& action, *actions_) {
		os << ", " << *action;
	}
	os << ")";
	return os;
}

} /* end ns Wccl */
