#ifndef LIBWCCL_OPS_ACTION_H
#define LIBWCCL_OPS_ACTION_H

#include <libwccl/ops/actionexeccontext.h>
#include <libwccl/ops/function.h>


namespace Wccl {

/**
 * Abstract base class for actions in WCCL rules
 */
class Action : public Expression
{
public:
	/**
	 * @returns Name of the action.
	 */
	virtual std::string name() const = 0;
	/**
	 * Executes the action for the given execution context.
	 */
	virtual Bool execute(const ActionExecContext& context) const = 0;
};

namespace detail {
	boost::shared_ptr<Function<Position> > CurrentPos();
}

} /* end ns Wccl */

#endif // LIBWCCL_OPS_ACTION_H
