#ifndef LIBWCCL_OPS_FUNCTIONS_BOOL_PREDICATES_INTERSECTS_H
#define LIBWCCL_OPS_FUNCTIONS_BOOL_PREDICATES_INTERSECTS_H

#include <libwccl/ops/functions/bool/predicates/setpredicate.h>

namespace Wccl {

/**
 * Class that realises a predicate checking if one set intersects with another
 */
template <class T>
class Intersects : public SetPredicate<T>
{
public:
	typedef typename SetPredicate<T>::SetFunctionPtr SetFunctionPtr;

	Intersects(const SetFunctionPtr& set1_expr, const SetFunctionPtr& set2_expr)
		: SetPredicate<T>(set1_expr, set2_expr)
	{
	}

	/**
	 * @returns Name of the function: "inter"
	 */
	std::string raw_name() const {
		return "inter";
	}

protected:
	typedef FunctionBase::BaseRetValPtr BaseRetValPtr;
	/**
	 * Take values for both sets and return True if they intersect,
	 * False otherwise.
	 */
	BaseRetValPtr apply_internal(const FunExecContext& context) const {
		const boost::shared_ptr<const T>& set1 = this->set1_expr_->apply(context);
		const boost::shared_ptr<const T>& set2 = this->set2_expr_->apply(context);
		return Predicate::evaluate(set1->intersects(*set2), context);
	}

};

} /* end ns Wccl */


#endif // LIBWCCL_OPS_FUNCTIONS_BOOL_PREDICATES_INTERSECTS_H
