#include <libwccl/ops/match/conditions/tokencondition.h>
#include <libwccl/values/tokenmatch.h>

namespace Wccl {
namespace Matching {

TokenCondition::TokenCondition(const boost::shared_ptr<Function<Bool> >& predicate)
	: _predicate(predicate)
{
	BOOST_ASSERT(_predicate);
}

std::string TokenCondition::name() const
{
	return _predicate->raw_name();
}

std::string TokenCondition::to_string(const Corpus2::Tagset& tagset) const
{
	return _predicate->to_string(tagset);
}

MatchResult TokenCondition::apply(const ActionExecContext& context) const
{
	int orig_iter = context.sentence_context().get_position();
	if (_predicate->apply(context)->get_value()) {
		boost::shared_ptr<TokenMatch> match(new TokenMatch(context.sentence_context().get_position()));
		// increase current sentence position by one after successful token match
		context.sentence_context().set_position(orig_iter + 1);
		return MatchResult(match);
	}
	else {
		context.sentence_context().set_position(orig_iter);
		return MatchResult();
	}
}

std::ostream& TokenCondition::write_to(std::ostream& os) const
{
	return os << *_predicate;
}

} /* end ns Matching */
} /* end ns Wccl */
