#include <libwccl/ops/match/conditions/repeatedmatch.h>
#include <libwccl/values/matchvector.h>
#include <sstream>

namespace Wccl {
namespace Matching {

RepeatedMatch::RepeatedMatch(const boost::shared_ptr<ConjConditions>& conditions)
	: _conditions(conditions)
{
	BOOST_ASSERT(_conditions);
}

MatchResult RepeatedMatch::apply(const ActionExecContext& context) const
{
	boost::shared_ptr<MatchVector> match(new MatchVector());
	int orig_pos = context.sentence_context().get_position();
	MatchResult res = _conditions->apply(context);
	if (res.matched()) {
		do {
			match->append(res.get_match());
			res = _conditions->apply(context);
		} while (res.matched());
		return MatchResult(match);
	}
	else {
		context.sentence_context().set_position(orig_pos);
		return MatchResult();
	}
}

std::string RepeatedMatch::to_string(const Corpus2::Tagset& tagset) const
{
	std::ostringstream ostream;
	ostream << name() << _conditions->to_string(tagset);
	return ostream.str();
}

std::ostream& RepeatedMatch::write_to(std::ostream& ostream) const
{
	return ostream << name() << *_conditions;
}

} /* end ns Matching */
} /* end ns Wccl */
