#ifndef LIBWCCL_OPS_MATCH_ACTIONS_OVERWRITEMATCH_H
#define LIBWCCL_OPS_MATCH_ACTIONS_OVERWRITEMATCH_H

#include <libwccl/ops/match/actions/markbase.h>

namespace Wccl {
namespace Matching {

class OverwriteMatch : public MarkBase
{
public:
	OverwriteMatch(
			const boost::shared_ptr<Function<Match> >& match_from,
			const boost::shared_ptr<Function<Match> >& match_to,
			const boost::shared_ptr<Function<Match> >& head_match,
			const std::string& annotation_name)
		: MarkBase(match_from, match_to, head_match, annotation_name)
	{
	}

	OverwriteMatch(
			const boost::shared_ptr<Function<Match> >& match_from,
			const boost::shared_ptr<Function<Match> >& match_to,
			const std::string& annotation_name)
		: MarkBase(match_from, match_to, match_from, annotation_name)
	{
	}

	OverwriteMatch(
			const boost::shared_ptr<Function<Match> >& match_from_to,
			const std::string& annotation_name)
		: MarkBase(match_from_to, match_from_to, match_from_to, annotation_name)
	{
	}

	/**
	 * @returns Name of the action.
	 */
	std::string name() const {
		return "remark";
	}

	/**
	 * Executes the action for the given execution context.
	 */
	void execute(const ActionExecContext& context) const;
};

} /* end ns Matching */
} /* end ns Wccl */

#endif // LIBWCCL_OPS_MATCH_ACTIONS_OVERWRITEMATCH_H
