#include <libwccl/ops/functions/bool/predicates/and.h>
#include <libpwrutils/foreach.h>

namespace Wccl {

And::BaseRetValPtr And::apply_internal(const FunExecContext& context) const
{
	foreach(boost::shared_ptr< Function<Bool> > expression, *expressions_) {
		if(!(expression->apply(context)->get_value())) {
			return Predicate::False(context);
		}
	}
	return Predicate::True(context);
}

} /* end ns Wccl */
