#include <libwccl/ops/functions/tset/agrfilter.h>
#include <libwccl/ops/functions/constant.h>

namespace Wccl {

std::string AgrFilter::to_string(const Corpus2::Tagset& tagset) const
{
	std::ostringstream os;
	os << name(tagset) << "("
		<< left_pos_expr_->to_string(tagset) << ", "
		<< right_pos_expr_->to_string(tagset) << ", "
		<< attribs_expr_-> to_string(tagset) << ", "
		<< mask_expr_-> to_string(tagset) << ")";
	return os.str();
}

std::ostream& AgrFilter::write_to(std::ostream& os) const
{
	return os << raw_name() << "("
			<< *left_pos_expr_ << ", "
			<< *right_pos_expr_ << ", "
			<< *attribs_expr_ << ", "
			<< *mask_expr_ << ")";
}

AgrFilter::BaseRetValPtr AgrFilter::apply_internal(const FunExecContext& context) const
{
	const SentenceContext& sc = context.sentence_context();

	const boost::shared_ptr<const Position>& range_left = left_pos_expr_->apply(context);
	if (range_left->get_value() == Position::Nowhere) {
		return detail::DefaultFunction<TSet>()->apply(context);
	}
	const boost::shared_ptr<const Position>& range_right = right_pos_expr_->apply(context);
	if (range_right->get_value() == Position::Nowhere) {
		return detail::DefaultFunction<TSet>()->apply(context);
	}
	// Get absolute values for left and right extremes of the range.
	int abs_left = sc.get_abs_position(*range_left);
	int abs_right = sc.get_abs_position(*range_right);
	// Trim range to sentence boundaries
	if (abs_left < 0) {
		abs_left = 0;
	}
	if (abs_right >= sc.size()) {
		abs_right = sc.size() - 1;
	}
	// Proceed only if range isn't empty (range outside of sentence or empty sentence are covered)
	if (abs_left > abs_right) {
		return detail::DefaultFunction<TSet>()->apply(context);
	}

	const boost::shared_ptr<const TSet>& attribs_tset = attribs_expr_->apply(context);
	const boost::shared_ptr<const TSet>& mask_tset = mask_expr_->apply(context);
	const Corpus2::Tag& attribs = attribs_tset->get_value();
	const Corpus2::Tag& mask = mask_tset->get_value();

	boost::shared_ptr<TSet> tset = boost::make_shared<TSet>();
	//
	//@ todo: implement
	//
	tset->contents().mask_with(mask);
	return tset;
}

} /* end ns Wccl */
