#ifndef LIBWCCL_OPS_FUNCTIONS_BOOL_ITERATIONS_LEFTLOOK_H
#define LIBWCCL_OPS_FUNCTIONS_BOOL_ITERATIONS_LEFTLOOK_H

#include <libwccl/ops/functions/bool/iteration.h>

namespace Wccl {

/**
 * Iterative operator "llook", which looks for the rightmost position
 * in a range that makes the evaluating expression return true, i.e.
 * it "looks to the left".
 */
class LeftLook : public Iteration
{
public:
	LeftLook(
		const PosFunctionPtr& left_pos_expr,
		const PosFunctionPtr& right_pos_expr,
		const VariableAccessor<Position>& iter_var_acc,
		const BoolFunctionPtr& evaluating_expr)
		: Iteration(left_pos_expr, right_pos_expr, iter_var_acc, evaluating_expr)
	{
	}

	/**
	 * @returns Name of the function: "llook".
	 */
	std::string raw_name() const {
		return "llook";
	}

protected:
	/**
	 * @returns True if, when scanning right-to-left,
	 * a position within the range is found that makes
	 * the evaluating function return true. False
	 * otherwise.
	 * @note Upon success, the iteration variable is
	 * set to the rightmost position in range
	 * that has made evaluation function return true
	 * (that is the position that made the stop condition
	 * true in this case).
	 */ 
	bool iterate(
		int left,
		int right,
		Position &p,
		const FunExecContext &context) const;
};


} /* end ns Wccl */

#endif // LIBWCCL_OPS_FUNCTIONS_BOOL_ITERATIONS_LEFTLOOK_H
