#ifndef LIBWCCL_OPS_VARGETTER_H
#define LIBWCCL_OPS_VARGETTER_H

#include <libwccl/ops/functions.h>

namespace Wccl {

/**
 * Operator that returns value of a variable of given type T
 */
template<class T>
class VarGetter : public Function<T> {
public:
	VarGetter(const VariableAccessor<T>& var_acc)
		: var_acc_(var_acc)
	{
	}
	
	/**
	 * @returns Function name for variable getter: "getvar"
	 */
	std::string raw_name() const {
		return "getvar";
	}

	/**
	 * @returns String representation of the variable getter which is
	 * equal to string representation of the underlying variable.
	 */
	std::string to_raw_string() const {
		return T::var_repr(var_acc_.get_name());
	}

	/**
	 * @returns String representation of the variable getter which is
	 * equal to string representation of the underlying variable.
	 */
	std::string to_string(const Corpus2::Tagset&) const {
		return T::var_repr(var_acc_.get_name());
	}

protected:
	typedef FunctionBase::BaseRetValPtr BaseRetValPtr;
	/**
	 * Return value held by the underlying variable.
	 */
	BaseRetValPtr apply_internal(const FunExecContext& context) const {
		return context.variables()->get_fast(var_acc_);
	}

private:
	const VariableAccessor<T> var_acc_;
};


} /* end ns Wccl */

#endif // LIBWCCL_OPS_VARGETTER_H
