#include <libwccl/ops/relativeposition.h>
#include <sstream>
#include <libwccl/ops/constant.h>

namespace Wccl {

RelativePosition::BaseRetValPtr RelativePosition::apply_internal(
	const FunExecContext &context) const
{
	static const Constant<Position> nowhere((Position(Position::Nowhere)));
	const RetValPtr& orig_pos = pos_expr_->apply(context);
	if(orig_pos->get_value() == Position::Nowhere) {
		return nowhere.apply(context);
	}
	const SentenceContext& sc = context.sentence_context();
	return RetValPtr(new Position(offset_ + sc.get_rel_position(*orig_pos)));
}

std::string RelativePosition::to_string(const Corpus2::Tagset &tagset) const
{
	std::stringstream ss;
	ss << pos_expr_->to_string(tagset);
	if(offset_ >= 0) {
		ss << " + " << offset_;
	} else {
		ss << " - " << -offset_;
	}
	return ss.str();
}

std::string RelativePosition::to_raw_string() const
{
	std::stringstream ss;
	ss << pos_expr_->to_raw_string();
	if(offset_ >= 0) {
		ss << " + " << offset_;
	} else {
		ss << " - " << -offset_;
	}
	return ss.str();
}

} /* end ns Wccl */
