#ifndef LIBWCCL_OPS_NOR_H
#define LIBWCCL_OPS_NOR_H

#include <libwccl/ops/logicalpredicate.h>

namespace Wccl {

/**
 * Operator that realises logical predicate "nor",
 * (note: the operator is called "not" in CCL)
 */
class Nor : public LogicalPredicate
{
public:
	Nor(const boost::shared_ptr<BoolFunctionPtrVector>& expressions)
		: LogicalPredicate(expressions)
	{
	}

	/**
	 * @returns Name of the function: "not"
	 */
	std::string raw_name() const {
		return "not";
	}

protected :
	/**
	 * "Nor" (aka "not") predicate evaluates expressions one by one in order
     * from left to right, and False is returned once an expression evaluating
     * to True is found.
	 * If all of the expressions were False, True is returned.
	 */
	BaseRetValPtr apply_internal(const FunExecContext&) const;

};

} /* end ns Wccl */
#endif // LIBWCCL_OPS_NOR_H
