#ifndef LIBWCCL_OPS_FUNCTIONS_TSET_GETWORDCLASS_H
#define LIBWCCL_OPS_FUNCTIONS_TSET_GETWORDCLASS_H

#include <libwccl/ops/functions/tset/getsymbols.h>

namespace Wccl {

/**
 * Operator that gets word class/part of speech symbols from
 * a token at given position.
 */
class GetWordClass : public GetSymbols {
public:
	typedef boost::shared_ptr<Function<Position> > PosFunctionPtr;

	GetWordClass(const PosFunctionPtr& pos_expr)
		: GetSymbols(Corpus2::Tag(-1), pos_expr)
	{
	}

	/**
	 * @returns Name of the operator, "flex"
	 */
	std::string name(const Corpus2::Tagset&) const {
		return "class";
	}
	/**
	 * @returns Name of the operator, "flex"
	 */
	std::string raw_name() const {
		return "class";
	}
};

} /* end ns Wccl */

#endif // LIBWCCL_OPS_FUNCTIONS_TSET_GETWORDCLASS_H
