#include <libwccl/ops/functions/strset/getlemmas.h>
#include <libwccl/ops/formatters.h>
#include <libwccl/ops/functions/constant.h>

namespace Wccl {

std::string GetLemmas::to_string(const Corpus2::Tagset& tagset) const
{
	return UnaryFunctionFormatter::to_string(tagset, *this, *pos_expr_, "[", "]");
}

std::string GetLemmas::to_raw_string() const {
	return UnaryFunctionFormatter::to_raw_string(*this, *pos_expr_, "[", "]");
}

GetLemmas::BaseRetValPtr GetLemmas::apply_internal(const FunExecContext& context) const
{
	const boost::shared_ptr<const Position>& pos = pos_expr_->apply(context);
	const SentenceContext& sc = context.sentence_context();
	if(pos->is_outside(sc) || !sc.is_current_inside()) {
		return detail::DefaultFunction<StrSet>()->apply(context);
	}
	boost::shared_ptr<StrSet> u_set = boost::make_shared<StrSet>();
	foreach(const Corpus2::Lexeme& lexeme, sc.at(*pos)->lexemes()) {
		u_set->insert(lexeme.lemma());
	}
	return u_set;
}

} /* end ns Wccl */
