#ifndef LIBWCCL_TESTS_OPTEST_H
#define LIBWCCL_TESTS_OPTEST_H

#include <libwccl/ops/functions/constant.h>
#include <libwccl/ops/function.h>
#include <libwccl/values/position.h>


namespace Wccl {

class PositionFixture
{
public:
	PositionFixture(int max_offset = 1);

	int max_offset() { return max_offset(); }

	Position begin_value() { return positions_[0]; }
	Position end_value() { return positions_[1]; }
	Position nowhere_value() { return positions_[2]; }
	Position pos_value(int offset) {
		return positions_[get_idx(offset)];
	}

	boost::shared_ptr< Wccl::Function<Position> > begin() { return constants_[0]; }
	boost::shared_ptr< Wccl::Function<Position> > end() { return constants_[1]; }
	boost::shared_ptr< Wccl::Function<Position> > nowhere() { return constants_[2]; }
	boost::shared_ptr< Wccl::Function<Position> > pos(int offset) {
		return constants_[get_idx(offset)];
	}

protected:

private:
	int get_idx(int offset) {
		assert(offset <= max_offset_);
		assert(offset >= -max_offset_);
		int idx = offset + max_offset_ + 3;
		assert(idx >= 0);
		assert(static_cast<size_t>(idx) < positions_.size());
		return idx;
	}

	int max_offset_;
	std::vector<Position> positions_;
	std::vector< boost::shared_ptr< Wccl::Function<Position> > > constants_;
};


} /* end ns Wccl */

#endif // LIBWCCL_TESTS_OPTEST_H
