#include "optest.h"

namespace Wccl {

PositionFixture::PositionFixture(int max_offset /*=1*/)
	: max_offset_(max_offset)
{
	assert(max_offset >= 0);
	positions_.push_back(Position(Position::Begin));
	positions_.push_back(Position(Position::End));
	positions_.push_back(Position(Position::Nowhere));
	for (int i = -max_offset; i <= max_offset; ++i) {
		positions_.push_back(Position(i));
	}
	for (size_t i = 0; i < positions_.size(); ++i) {
		constants_.push_back(
			boost::make_shared< Constant<Position> >(positions_[i]));
	}
}

} /* end ns Wccl */
