#include <cstdlib>

#include <libwccl/values/strset.h>
#include <libwccl/parser/Parser.h>

// ----------------------------------------------------------------------------

/**
 * @desc It's simple command line tester for testing string operators
 */

int main()
{
  std::string str_in;
  Corpus2::Tagset tagset;
	Parser parser(tagset);

	boost::shared_ptr<Wccl::StrSet> retStr;
	boost::shared_ptr<Wccl::Function<Wccl::StrSet> > retOp;
	boost::shared_ptr<Corpus2::Sentence> sentence;
	Wccl::SentenceContext sc(sentence);

  while (1) {
    std::cerr << "Enter a string operator expression: ";

    getline(std::cin, str_in);

    if (str_in == "clear" || str_in == "cls") {
      if (system("clear")) {
        //  
      }
    }
		else if (str_in == "exit" || str_in == "quit") {
			break;
		}
    else {
			try {
	      retOp = parser.parseStringOperator(str_in);

				if (retOp.get()) {
					if ((retStr = retOp->apply(sc)).get()) {
						std::cerr << "Parsed expression: " << retStr->to_raw_string() << std::endl;
					}
					else {
						std::cerr << "Problem while parsing -- haven't got StrSet object in boost::shared_ptr!" << std::endl;
					}
				}
				else {
					std::cerr << "Problem while parsing -- haven't got Function<Wccl::StrSet> object in boost::shared_ptr!" << std::endl;
				}
			}
			catch (antlr::MismatchedTokenException &e) {
				std::cerr << "Mismatch token exception!" << std::endl;
			}
			/*
			catch (antlr::TokenStreamRecognitionException &e) {
				std::cerr << "[2] Syntax error!" << std::endl;
			}
			*/
			catch (...) {
				std::cerr << "[N] Syntax error!" << std::endl;
			}
    }
  }

  return 0;
}

