#include <boost/test/unit_test.hpp>
#include <boost/bind.hpp>
#include <boost/shared_ptr.hpp>

#include <libwccl/ops/constant.h>
#include <libwccl/variables.h>
#include <libwccl/values/bool.h>
#include <libwccl/sentencecontext.h>


using namespace Wccl;

BOOST_AUTO_TEST_SUITE(constant)

struct BoolFix
{
	BoolFix()
		: sc(boost::make_shared<Corpus2::Sentence>()),
		  cx(sc, boost::make_shared<Variables>()),
		  tagset(),
		  true_value(true),
		  false_value(false),
		  true_constant(true_value),
		  false_constant(false_value)
	{
	}
	SentenceContext sc;
	FunExecContext cx;
	Corpus2::Tagset tagset;

	Bool true_value;
	Bool false_value;
	Constant<Bool> true_constant;
	Constant<Bool> false_constant;
};

BOOST_FIXTURE_TEST_CASE(bool_apply, BoolFix)
{
	BOOST_CHECK_EQUAL(true, true_value.get_value());
	BOOST_CHECK_EQUAL(true, true_constant.apply(cx)->get_value());
	BOOST_CHECK_EQUAL(false, false_value.get_value());
	BOOST_CHECK_EQUAL(false, false_constant.apply(cx)->get_value());
}

BOOST_FIXTURE_TEST_CASE(bool_to_string, BoolFix)
{
	BOOST_CHECK_EQUAL("True", true_value.to_string(tagset));
	BOOST_CHECK_EQUAL(true_value.to_string(tagset), true_constant.to_string(tagset));
	BOOST_CHECK_EQUAL("False", false_value.to_string(tagset));
	BOOST_CHECK_EQUAL(false_value.to_string(tagset), false_constant.to_string(tagset));
}

BOOST_FIXTURE_TEST_CASE(bool_to_raw_string, BoolFix)
{
	BOOST_CHECK_EQUAL("True", true_value.to_raw_string());
	BOOST_CHECK_EQUAL(true_value.to_raw_string(), true_constant.to_raw_string());
	BOOST_CHECK_EQUAL("False", false_value.to_raw_string());
	BOOST_CHECK_EQUAL(false_value.to_raw_string(), false_constant.to_raw_string());
}

BOOST_AUTO_TEST_SUITE_END()
