/*
    Copyright (C) 2011 Adam Wardyński, Tomasz Śniatowski, Paweł Kędzia,
    Adam Radziszewski, Bartosz Broda
    Part of the WCCL project

    This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the Free
Software Foundation; either version 3 of the License, or (at your option)
any later version.

    This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE. 

    See the LICENSE and COPYING files for more details.
*/

#include <libwccl/ops/functions/bool/predicates/nor.h>
#include <libpwrutils/foreach.h>

namespace Wccl {

Nor::BaseRetValPtr Nor::apply_internal(const FunExecContext& context) const
{
	foreach(BoolFunctionPtr expression, *expressions_) {
		if(expression->apply(context)->get_value()) {
			return Predicate::False(context);
		}
	}
	return Predicate::True(context);
}

} /* end ns Wccl */
