#include <libwccl/ops/match/conditions/conjconditions.h>
#include <libwccl/values/matchvector.h>
#include <libpwrutils/foreach.h>
#include <sstream>

namespace Wccl {

ConjConditions::ConjConditions(const std::vector< boost::shared_ptr<const MatchCondition> >& conditions)
	: _conditions(conditions)
{
	BOOST_ASSERT(_conditions.size() > 0);
}

MatchResult ConjConditions::apply(const ActionExecContext& context) const
{
	boost::shared_ptr<MatchVector> matches(new MatchVector());
	int orig_pos = context.sentence_context().get_position();

	foreach (const boost::shared_ptr<const MatchCondition>& cond, _conditions) {
		MatchResult res = cond->apply(context);
		if(res.matched()) {
			matches->append(res.get_match());
		} else {
			context.sentence_context().set_position(orig_pos);
			return MatchResult();
		}
	}
	return MatchResult(matches);
}

std::string ConjConditions::to_string(const Corpus2::Tagset& tagset) const
{
	std::ostringstream ostream;
	ostream << "(";
	for(size_t i = 0; i < _conditions.size(); ++i) {
		if (i != 0) {
			ostream << ", ";
		}
		ostream << _conditions[i]->to_string(tagset);
	}
	ostream << ")";
	return ostream.str();
}

std::ostream& ConjConditions::write_to(std::ostream &ostream) const
{
	ostream << "(";
	for(size_t i = 0; i < _conditions.size(); ++i) {
		if (i != 0) {
			ostream << ", ";
		}
		ostream << *_conditions[i];
	}
	ostream << ")";
	return ostream;
}

} /* end ns Wccl */
