#include <libwccl/ops/functions/strset/getorth.h>
#include <libwccl/ops/formatters.h>
#include <libwccl/ops/functions/constant.h>

namespace Wccl {

std::string GetOrth::to_string(const Corpus2::Tagset& tagset) const
{
	return UnaryFunctionFormatter::to_string(tagset, *this, *pos_expr_, "[", "]");
}

std::ostream& GetOrth::write_to(std::ostream& os) const
{
	return os << raw_name() << "[" << *pos_expr_ << "]";
}

GetOrth::BaseRetValPtr GetOrth::apply_internal(const FunExecContext& context) const
{
	const boost::shared_ptr<const Position>& pos = pos_expr_->apply(context);
	const SentenceContext& sc = context.sentence_context();
	if (sc.is_outside(*pos)) {
		return detail::DefaultFunction<StrSet>()->apply(context);
	}
	boost::shared_ptr<StrSet> u_set = boost::make_shared<StrSet>();
	u_set->insert(sc.at(*pos)->orth());
	return u_set;
}

} /* end ns Wccl */
