#ifndef LIBWCCL_OPS_FUNCTIONS_BOOL_ITERATIONS_ONLY_H
#define LIBWCCL_OPS_FUNCTIONS_BOOL_ITERATIONS_ONLY_H

#include <libwccl/ops/functions/bool/iteration.h>

namespace Wccl {

/**
 * Iterative operator "only", which mandates that
 * evaluating expression should evaluate to true
 * on all positions in range.
 */
class Only : public Iteration
{
public:
	Only(
		const PosFunctionPtr& left_pos_expr,
		const PosFunctionPtr& right_pos_expr,
		const VariableAccessor<Position>& iter_var_acc,
		const BoolFunctionPtr& evaluating_expr)
		: Iteration(left_pos_expr, right_pos_expr, iter_var_acc, evaluating_expr)
	{
	}

	/**
	 * @returns Name of the function: "only".
	 */
	std::string raw_name() const {
		return "only";
	}

protected:
	/**
	 * @returns True, if for all positions within range
	 * the evaluating expression returned true. False
	 * otherwise.
	 * @note Upon success, the iteration variable is
	 * set to the last position in range (that is the
	 * position that made the stop condition true in this case).
	 */ 
	bool iterate(
		int left,
		int right,
		Position &p,
		const FunExecContext &context) const;
};


} /* end ns Wccl */

#endif // LIBWCCL_OPS_FUNCTIONS_BOOL_ITERATIONS_ONLY_H
