#include <boost/test/unit_test.hpp>
#include <boost/bind.hpp>

#include <libwccl/variables.h>
#include <libpwrutils/foreach.h>

#include <iostream>

using namespace Wccl;

BOOST_AUTO_TEST_SUITE(varaccess);

struct VAfx
{
	boost::shared_ptr<Variables> v;
	VAfx() {
		Variables v2;
		v2.put("a", new Bool(true));
		v2.put("b", new Bool(true));
		v2.put("c", new Bool(true));
		v2.put("bb", new Bool(true));
		v2.put("aa", new Position(1));
		v2.put("aaa", new Position(2));
		v.reset(v2.clone());
	}
};


BOOST_FIXTURE_TEST_CASE(access, VAfx)
{
	std::vector<std::string> vnames;
	vnames.push_back("a");
	vnames.push_back("b");
	vnames.push_back("c");
	vnames.push_back("bb");
	foreach (const std::string vn, vnames) {
		VariableAccessor<Bool> a1 = v->create_accessor<Bool>(vn);
		BOOST_CHECK(v->get_fast(a1) == v->get<Bool>(vn));
		v->set("a", Bool(false));
		BOOST_CHECK(v->get_fast(a1) == v->get<Bool>(vn));
		v->put("a", Bool(true));
		BOOST_CHECK(v->get_fast(a1) == v->get<Bool>(vn));
	}
}

BOOST_FIXTURE_TEST_CASE(badaccess, VAfx)
{
	BOOST_CHECK_THROW(v->create_accessor<Bool>("asd"), InvalidVariableName);
	BOOST_CHECK_THROW(v->create_accessor<Bool>("aaa"), VariableTypeMismatch);
}


BOOST_AUTO_TEST_SUITE_END()

