#include <boost/test/unit_test.hpp>
#include <boost/bind.hpp>
#include <libcorpus2/tagsetmanager.h>

#include <libwccl/sentencecontext.h>
#include <libwccl/variables.h>

#include <iostream>

using namespace Wccl;

BOOST_AUTO_TEST_SUITE(values)

BOOST_AUTO_TEST_CASE(boolz)
{
	Bool b;
	BOOST_CHECK_EQUAL(b.get_value(), false);
	Value& v = b;
	BOOST_CHECK_EQUAL(v.get_type_name(), Bool::type_name);
}

BOOST_AUTO_TEST_CASE(tsetz)
{
	TSet t;
	BOOST_CHECK(t.get_value().is_null());
	Value& v = t;
	BOOST_CHECK_EQUAL(v.get_type_name(), TSet::type_name);
}

BOOST_AUTO_TEST_CASE(positionz)
{
	Position p;
	BOOST_CHECK(p.get_value() == Position::Nowhere);
	Value& v = p;
	BOOST_CHECK_EQUAL(v.get_type_name(), Position::type_name);
}

BOOST_AUTO_TEST_CASE(strset_ops)
{
	StrSet s1, s2;
	BOOST_CHECK(s1.equals(s2));
	BOOST_CHECK(s1.is_subset_of(s2));
	BOOST_CHECK(s2.is_subset_of(s1));
	BOOST_CHECK(!s1.intersects(s2));
	s1.insert_utf8("aaa");
	BOOST_CHECK(!s1.equals(s2));
	BOOST_CHECK(!s1.is_subset_of(s2));
	BOOST_CHECK(s2.is_subset_of(s1));
	BOOST_CHECK(!s1.intersects(s2));
	s2.insert_utf8("bbb");
	BOOST_CHECK(!s1.equals(s2));
	BOOST_CHECK(!s1.is_subset_of(s2));
	BOOST_CHECK(!s2.is_subset_of(s1));
	BOOST_CHECK(!s1.intersects(s2));
	s2.insert_utf8("aaa");
	BOOST_CHECK(!s1.equals(s2));
	BOOST_CHECK(s1.is_subset_of(s2));
	BOOST_CHECK(!s2.is_subset_of(s1));
	BOOST_CHECK(s1.intersects(s2));
	s1.insert_utf8("bbb");
	BOOST_CHECK(s1.equals(s2));
	BOOST_CHECK(s1.is_subset_of(s2));
	BOOST_CHECK(s2.is_subset_of(s1));
	BOOST_CHECK(s1.intersects(s2));
}

BOOST_AUTO_TEST_CASE(tset_ops)
{
	TSet s1, s2;
	const Corpus2::Tagset& tagset = Corpus2::get_named_tagset("kipi");
	BOOST_CHECK(s1.equals(s2));
	BOOST_CHECK(s1.is_subset_of(s2));
	BOOST_CHECK(s2.is_subset_of(s1));
	BOOST_CHECK(!s1.intersects(s2));
	s1.insert_symbol(tagset, "subst");
	BOOST_CHECK(!s1.equals(s2));
	BOOST_CHECK(!s1.is_subset_of(s2));
	BOOST_CHECK(s2.is_subset_of(s1));
	BOOST_CHECK(!s1.intersects(s2));
	s2.insert_symbol(tagset, "pl");
	BOOST_CHECK(!s1.equals(s2));
	BOOST_CHECK(!s1.is_subset_of(s2));
	BOOST_CHECK(!s2.is_subset_of(s1));
	BOOST_CHECK(!s1.intersects(s2));
	s2.insert_symbol(tagset, "subst");
	BOOST_CHECK(!s1.equals(s2));
	BOOST_CHECK(s1.is_subset_of(s2));
	BOOST_CHECK(!s2.is_subset_of(s1));
	BOOST_CHECK(s1.intersects(s2));
	s1.insert_symbol(tagset, "pl");
	BOOST_CHECK(s1.equals(s2));
	BOOST_CHECK(s1.is_subset_of(s2));
	BOOST_CHECK(s2.is_subset_of(s1));
	BOOST_CHECK(s1.intersects(s2));
}

BOOST_AUTO_TEST_CASE(position_ops)
{
	boost::shared_ptr<Corpus2::Sentence> s(boost::make_shared<Corpus2::Sentence>());
	SentenceContext sc(s);
	Corpus2::Token* a_token = new Corpus2::Token("ZZ", PwrNlp::Whitespace::ManySpaces);
	Corpus2::Tag t1(Corpus2::mask_t(0));
	Corpus2::Lexeme l1("aaa", t1);
	Corpus2::Lexeme l2("bbb", t1);
	a_token->add_lexeme(l1);
	a_token->add_lexeme(l2);
	s->append(a_token);
	s->append(a_token->clone());
	Position begin(Position::Begin);
	Position end(Position::End);
	Position nowhere(Position::Nowhere);
	Position zero(0);
	Position one(1);
	Position minus_one(-1);
	Position minus_two(-2);

	std::vector<Position> v;
	v.push_back(begin);
	v.push_back(end);
	v.push_back(nowhere);
	v.push_back(zero);
	v.push_back(one);
	v.push_back(minus_one);
	v.push_back(minus_two);
	
	for(size_t i = 0; i < v.size(); ++i) {
		for(size_t j = 0; j < v.size(); ++j) {
			BOOST_CHECK_EQUAL(i == j, v[i].equals(v[j]));
			BOOST_CHECK_EQUAL(i == j, v[j].equals(v[i]));
			if(i >= 2 && j >= 2) { //nowhere, zero, one, minus_one, minus_two
				BOOST_CHECK_EQUAL(i == j, v[j].equals(v[i], sc));
				BOOST_CHECK_EQUAL(i == j, v[j].equals(v[i], sc));
				sc.advance();
				BOOST_CHECK_EQUAL(i == j, v[j].equals(v[i], sc));
				BOOST_CHECK_EQUAL(i == j, v[j].equals(v[i], sc));
				sc.advance();
				BOOST_CHECK_EQUAL(i == j, v[j].equals(v[i], sc));
				BOOST_CHECK_EQUAL(i == j, v[j].equals(v[i], sc));
				sc.goto_start();
			}
		}
	}
	sc.goto_start();
	BOOST_CHECK(begin.equals(zero, sc));
	BOOST_CHECK(zero.equals(begin, sc));
	BOOST_CHECK(one.equals(end, sc));
	BOOST_CHECK(end.equals(one, sc));
	sc.advance();
	BOOST_CHECK(begin.equals(minus_one, sc));
	BOOST_CHECK(minus_one.equals(begin, sc));
	BOOST_CHECK(zero.equals(end, sc));
	BOOST_CHECK(end.equals(zero, sc));
	sc.advance();
	BOOST_CHECK(begin.equals(minus_two, sc));
	BOOST_CHECK(minus_two.equals(begin, sc));
	BOOST_CHECK(minus_one.equals(end, sc));
	BOOST_CHECK(end.equals(minus_one, sc));
}

BOOST_AUTO_TEST_SUITE_END()
