//#define BOOST_TEST_MODULE master
#include <boost/test/included/unit_test.hpp>
#include <unicode/uclean.h>

BOOST_AUTO_TEST_CASE(test_test)
{
	int a = 0;
	BOOST_CHECK(a == 0);
}

//Auto cleanup of ICU with a static variable destructor.
//ICU can hold onto some memory resources until program exit,
//when the system is reclaiming them as usual. This is not a memory
//leak but makes tools like valgrind all excited that
//there is memory which is "still reachable but not freed."
//So, the below will perform icu cleanup before test program exit.
static struct ICU_cleaner
{
	~ICU_cleaner()
	{
		u_cleanup();
	}
} the_cleaner;

boost::unit_test::test_suite* init_unit_test_suite(int /*argc*/, char* /*argv*/[])
{
	return 0;
}
