#include <boost/test/unit_test.hpp>
#include <boost/bind.hpp>
#include <boost/shared_ptr.hpp>
#include <libcorpus2/sentence.h>

#include <libwccl/ops/functions/constant.h>
#include <libwccl/ops/functions/strset/getorth.h>

using namespace Wccl;

BOOST_AUTO_TEST_SUITE(relative_position)

struct OrthPredFix
{
	OrthPredFix()
		: s(boost::make_shared<Corpus2::Sentence>()),
		  sc(s),
		  tagset(),
		  cx(sc, boost::make_shared<Variables>()),
		  pos_zero(0),
		  pos_one(1),
		  pos_minus_one(-1),
		  nowhere(Position::Nowhere),
		  begin(Position::Begin),
		  end(Position::End),
		  pos_zero_constant(new Constant<Position>(pos_zero)),
		  pos_one_constant(new Constant<Position>(pos_one)),
		  pos_minus_one_constant(new Constant<Position>(pos_minus_one)),
		  nowhere_constant(new Constant<Position>(nowhere)),
		  begin_constant(new Constant<Position>(begin)),
		  end_constant(new Constant<Position>(end)),
		  empty_set(),
		  first_orth(),
		  second_orth()
	{
		first_orth.insert("One");
		second_orth.insert("two");
		Corpus2::Token* the_token = new Corpus2::Token(
				*first_orth.contents().begin(),
				PwrNlp::Whitespace::ManySpaces);
		Corpus2::Tag t1(Corpus2::mask_t(0));
		Corpus2::Lexeme l1("aaa", t1);
		Corpus2::Lexeme l2("bbb", t1);
		the_token->add_lexeme(l1);
		the_token->add_lexeme(l2);
		s->append(the_token);
		Corpus2::Token* another_token = new Corpus2::Token(
				*second_orth.contents().begin(),
				PwrNlp::Whitespace::ManySpaces);
		Corpus2::Tag t2(Corpus2::mask_t(0));
		Corpus2::Lexeme l3("ccc", t2);
		Corpus2::Lexeme l4("ddd", t2);
		another_token->add_lexeme(l3);
		another_token->add_lexeme(l4);
		s->append(another_token);
	}

	boost::shared_ptr<Corpus2::Sentence> s;
	SentenceContext sc;
	Corpus2::Tagset tagset;

	FunExecContext cx;
	Position pos_zero;
	Position pos_one;
	Position pos_minus_one;
	Position nowhere;
	Position begin;
	Position end;
	boost::shared_ptr<Function<Position> > pos_zero_constant;
	boost::shared_ptr<Function<Position> > pos_one_constant;
	boost::shared_ptr<Function<Position> > pos_minus_one_constant;
	boost::shared_ptr<Function<Position> > nowhere_constant;
	boost::shared_ptr<Function<Position> > begin_constant;
	boost::shared_ptr<Function<Position> > end_constant;
	StrSet empty_set;
	StrSet first_orth;
	StrSet second_orth;

};

BOOST_FIXTURE_TEST_CASE(orth_nowhere, OrthPredFix)
{
	GetOrth orth(nowhere_constant);
	BOOST_CHECK(orth.apply(cx)->equals(empty_set));
	sc.advance();
	BOOST_CHECK(orth.apply(cx)->equals(empty_set));
	sc.advance();
	BOOST_CHECK(orth.apply(cx)->equals(empty_set));
	sc.goto_start();
}

BOOST_FIXTURE_TEST_CASE(orth_begin, OrthPredFix)
{
	GetOrth orth(begin_constant);
	BOOST_CHECK(orth.apply(cx)->equals(first_orth));
	sc.advance();
	BOOST_CHECK(orth.apply(cx)->equals(first_orth));
	sc.advance();
	BOOST_CHECK(orth.apply(cx)->equals(empty_set));
	sc.goto_start();
}

BOOST_FIXTURE_TEST_CASE(orth_end, OrthPredFix)
{
	GetOrth orth(end_constant);
	BOOST_CHECK(orth.apply(cx)->equals(second_orth));
	sc.advance();
	BOOST_CHECK(orth.apply(cx)->equals(second_orth));
	sc.advance();
	BOOST_CHECK(orth.apply(cx)->equals(empty_set));
	sc.goto_start();
}

BOOST_FIXTURE_TEST_CASE(orth_zero, OrthPredFix)
{
	GetOrth orth(pos_zero_constant);
	BOOST_CHECK(orth.apply(cx)->equals(first_orth));
	sc.advance();
	BOOST_CHECK(orth.apply(cx)->equals(second_orth));
	sc.advance();
	BOOST_CHECK(orth.apply(cx)->equals(empty_set));
	sc.goto_start();
}

BOOST_FIXTURE_TEST_CASE(orth_one, OrthPredFix)
{
	GetOrth orth(pos_one_constant);
	BOOST_CHECK(orth.apply(cx)->equals(second_orth));
	sc.advance();
	BOOST_CHECK(orth.apply(cx)->equals(empty_set));
	sc.advance();
	BOOST_CHECK(orth.apply(cx)->equals(empty_set));
	sc.goto_start();
}

BOOST_FIXTURE_TEST_CASE(orth_minus_one, OrthPredFix)
{
	GetOrth orth(pos_minus_one_constant);
	BOOST_CHECK(orth.apply(cx)->equals(empty_set));
	sc.advance();
	BOOST_CHECK(orth.apply(cx)->equals(first_orth));
	sc.advance();
	BOOST_CHECK(orth.apply(cx)->equals(empty_set));
	sc.goto_start();
}
//------ to_string test cases -------

BOOST_FIXTURE_TEST_CASE(orth_to_string, OrthPredFix)
{
	GetOrth orth(begin_constant);
	BOOST_CHECK_EQUAL("orth[begin]", orth.to_string(tagset));
}

BOOST_FIXTURE_TEST_CASE(orth_to_raw_string, OrthPredFix)
{
	GetOrth orth(end_constant);
	BOOST_CHECK_EQUAL("orth[end]", orth.to_string(tagset));
	GetOrth orth2(pos_minus_one_constant);
	BOOST_CHECK_EQUAL("orth[-1]", orth2.to_string(tagset));
}
BOOST_AUTO_TEST_SUITE_END()
