#ifndef LIBWCCL_OPS_FUNCTIONS_BOOL_PREDICATES_AND_H
#define LIBWCCL_OPS_FUNCTIONS_BOOL_PREDICATES_AND_H

#include <libwccl/ops/functions/bool/predicates/logicalpredicate.h>

namespace Wccl {

/**
 * Operator that realises "and" logical predicate
 */
class And : public LogicalPredicate
{
public:
	And(const boost::shared_ptr<BoolFunctionPtrVector>& expressions)
		: LogicalPredicate(expressions)
	{
	}

	/**
	 * @returns Name of the function: "and"
	 */
	std::string raw_name() const {
		return "and";
	}

protected :
	/**
	 * "And" predicate evaluates each expression from left to right,
     * and returns False once an expression evaluating to False is found.
     * If all expressions were True, it returns True.
	 */
	BaseRetValPtr apply_internal(const FunExecContext& context) const;

};

} /* end ns Wccl */
#endif // LIBWCCL_OPS_FUNCTIONS_BOOL_PREDICATES_AND_H
