#include <libwccl/ops/functions/strset/tolower.h>
#include <libwccl/ops/formatters.h>

namespace Wccl {

std::string ToLower::to_string(const Corpus2::Tagset& tagset) const
{
	return UnaryFunctionFormatter::to_string(tagset, *this, *strset_expr_);
}

std::string ToLower::to_raw_string() const {
	return UnaryFunctionFormatter::to_raw_string(*this, *strset_expr_);
}

ToLower::BaseRetValPtr ToLower::apply_internal(const FunExecContext& context) const {	
	const boost::shared_ptr<const StrSet >& set = strset_expr_->apply(context);
	boost::shared_ptr<StrSet > l_set = boost::make_shared<StrSet>();
	//TODO: should tolower be a method of StrSet as well?
	foreach(const UnicodeString& s, set->contents()) {
		//TODO: what about locale? is default ok? should the context hold it?
		l_set->insert(UnicodeString(s).toLower());
	}
	return l_set;
}

} /* end ns Wccl */
