#ifndef LIBWCCL_OPS_SETPREDICATE_H
#define LIBWCCL_OPS_SETPREDICATE_H

#include <boost/mpl/list.hpp>
#include <boost/mpl/count.hpp>
#include <libwccl/ops/predicate.h>
#include <libwccl/values/strset.h>
#include <libwccl/values/tset.h>

#include <libwccl/ops/formatters.h>

namespace Wccl {

/**
 * Abstract base class for predicates which operate on two sets
 */
template<class T>
class SetPredicate : public Predicate {
	BOOST_MPL_ASSERT(( boost::mpl::count<boost::mpl::list<StrSet, TSet>, T> ));
public:
	typedef boost::shared_ptr<Function<T> > SetFunctionPtr;

	SetPredicate(const SetFunctionPtr& set1_expr, const SetFunctionPtr& set2_expr)
		: set1_expr_(set1_expr), set2_expr_(set2_expr)
	{
		BOOST_ASSERT(set1_expr_);
		BOOST_ASSERT(set2_expr_);
	}

	/**
	 * @returns String representation of the function in form of:
	 * "name_string(arg1_expr_string, arg2_expr_string)"
	 */
	std::string to_string(const Corpus2::Tagset& tagset) const {
		return BinaryFunctionFormatter::to_string(tagset, *this, *set1_expr_, *set2_expr_);
	}

	/**
	 * @returns String representation of the function in form of:
	 * "raw_name_string(arg1_expr_raw_string, arg2_expr_raw_string)"
	 * @note This version does not require a tagset, but may be inclomplete
	 * and/or contain internal info.
	 */	
	std::string to_raw_string() const {
		return BinaryFunctionFormatter::to_raw_string(*this, *set1_expr_, *set2_expr_);
	}

protected:
	const SetFunctionPtr set1_expr_;
	const SetFunctionPtr set2_expr_;
};

} /* end ns Wccl */

#endif // LIBWCCL_OPS_SETPREDICATE_H
