#ifndef LIBWCCL_OPS_OPERATOR_H
#define LIBWCCL_OPS_OPERATOR_H

#include <libcorpus2/tagset.h>
#include <unicode/unistr.h>
#include <boost/noncopyable.hpp>

namespace Wccl {

/**
 * Abstract base class for WCCL operators
 */
class Operator : public boost::noncopyable {
public:
	/**
	 * Name of the Operator, in general a tagset is required,
	 * but some classes might not need that, so by default just forward
	 * to raw_operator_name();
	 */
	virtual const std::string operator_name(const Corpus2::Tagset& /*tagset*/) const {
		return raw_operator_name();
	}
	/**
	 * Name of the Operator that does not require a tagset,
	 * might be incomplete and/or contain internal info.
	 *
	 * Prefer operator_name(tagset).
	 */
	virtual const std::string raw_operator_name() const = 0;
	/**
	 * String representation of the operator, by default it's just
	 * the name of the operator returned by operator_name(tagset)
	 */
	virtual std::string to_string(const Corpus2::Tagset& tagset) const {
		return operator_name(tagset);
	}
	/**
	 * String representation of the operator that does not require a tagset,
	 * might be incomplete and/or contain internal info.
	 *
	 * By default it is just the raw_operator_name()
	 */
	virtual std::string to_raw_string() const {
		return raw_operator_name();
	}
};

} /* end ns Wccl */

#endif // LIBWCCL_OPS_OPERATOR_H
