#include <libwccl/ops/logicalpredicate.h>

#include <sstream>

namespace Wccl {

std::string LogicalPredicate::to_string(const Corpus2::Tagset& tagset) const
{
	std::stringstream ss;
	ss << name(tagset) << "(";
	BoolFunctionPtrVector::const_iterator it = expressions_->begin();
	while(it != expressions_->end()) {
		ss << (*it)->to_string(tagset);
		if(++it != expressions_->end()) {
			ss << ", ";
		}
	}
	ss << ")";
	return ss.str();
}

std::string LogicalPredicate::to_raw_string() const
{
	std::stringstream ss;
	ss << raw_name() << "(";
	BoolFunctionPtrVector::const_iterator it = expressions_->begin();
	while(it != expressions_->end()) {
		ss << (*it)->to_raw_string();
		if(++it != expressions_->end()) {
			ss << ", ";
		}
	}
	ss << ")";
	return ss.str();
}

} /* end ns Wccl */
