#ifndef LIBWCCL_OPS_INTERSECTS_H
#define LIBWCCL_OPS_INTERSECTS_H

#include <libwccl/ops/setpredicate.h>

namespace Wccl {

/**
 * Class that realises a predicate checking if one set intersects with another
 */
template <class T>
class Intersects : public SetPredicate<T>
{
public:
	Intersects(const SetFunctionPtr& set1_expr, const SetFunctionPtr& set2_expr)
		: SetPredicate<T>(set1_expr, set2_expr)
	{
	}

	/**
	 * @returns Name of the function: "inter"
	 */
	std::string raw_name() const {
		return "inter";
	}

protected:
	/**
	 * Take values for both sets and return True if they intersect,
	 * False otherwise.
	 */
	BaseRetValPtr apply_internal(const FunExecContext& context) const {
		boost::shared_ptr<T> set1 = this->set1_expr_->apply(context);
		boost::shared_ptr<T> set2 = this->set2_expr_->apply(context);
		return Predicate::evaluate(set1->intersects(*set2), context);
	}

};

} /* end ns Wccl */


#endif // LIBWCCL_OPS_INTERSECTS_H
