#ifndef LIBWCCL_OPS_AFFIX_H
#define LIBWCCL_OPS_AFFIX_H

#include <libwccl/values/strset.h>
#include <libwccl/ops/functions.h>

namespace Wccl {

/**
 * Operator that takes a set of strings and returns a new
 * set with corresponding values that are prefixes or
 * suffixes of given length
 */
class Affix : public Function<StrSet> {
public:
	typedef boost::shared_ptr<Function<StrSet> > StrSetFunctionPtr;
	
	Affix(const StrSetFunctionPtr& strset_expr, int affix_length)
		: strset_expr_(strset_expr),
		  affix_length_(affix_length)
	{
		BOOST_ASSERT(strset_expr_);
	}

	/**
	 * String representation of the operator in form of:
	 * "affix(strset_expr_string)"
	 */
	std::string to_string(const Corpus2::Tagset& tagset) const;

	/**
	 * String representation of conditional operator in form of:
	 * "affix(strset_expr_raw_string)"
	 * This version does not require tagset, but may be inclomplete
	 * and/or contain internal info.
	 */
	std::string to_raw_string() const;

	/**
	 * @returns Name of the function: "affix"
	 */
	std::string raw_name() const {
		return "affix";
	}

protected:
	const StrSetFunctionPtr strset_expr_;
	const int affix_length_;

	/**
	 * Get a string set from the argument expression and return copy of the set
	 * with all strings converted into prefixes or suffixes of given length
	 */
	BaseRetValPtr apply_internal(const FunExecContext& context) const;
};

} /* end ns Wccl */

#endif // LIBWCCL_OPS_AFFIX_H
