#ifndef LIBWCCL_OPS_PREDICATE_H
#define LIBWCCL_OPS_PREDICATE_H

#include <boost/scoped_ptr.hpp>

#include <libwccl/values/bool.h>
#include <libwccl/ops/constant.h>

namespace Wccl {

/**
 * Abstract base class for Predicates (operators returning Bool)
 */
class Predicate : public Function<Bool> {
public:
	/**
	 * Helper function returing True, to use by predicates when returning value
	 */
	static RetValPtr True(const FunExecContext& context);
	/**
	 * Helper function returing False, to use by predicates when returning value
	 */
	static RetValPtr False(const FunExecContext& context);
	/**
	 * Helper function returing True or False depending on condition
	 */
	static RetValPtr evaluate(bool condition, const FunExecContext& context);
};

} /* end ns Wccl */

#endif // LIBWCCL_OPS_PREDICATE_H
