#include <libwccl/ops/formatters.h>
#include <sstream>

namespace Wccl {

// ------ UnaryFunctionFormatter -----

std::string UnaryFunctionFormatter::to_string(
	const Corpus2::Tagset& tagset,
	const FunctionBase& f,
	const std::string& arg_str,
	const char* open_bracket,
	const char* close_bracket)
{
	std::stringstream ss;
	ss << f.name(tagset) << open_bracket << arg_str << close_bracket;
	return ss.str();
}

// ----- BinaryFunctionFormatter ------

std::string BinaryFunctionFormatter::to_string(
	const Corpus2::Tagset& tagset,
	const FunctionBase& f,
	const std::string& arg1_str,
	const std::string& arg2_str)
{
	std::stringstream ss;
	ss << f.name(tagset) << "(" << arg1_str << ", " << arg2_str << ")";
	return ss.str();
}

} /* end ns Wccl */
