#ifndef LIBWCCL_OPS_VARGETTER_H
#define LIBWCCL_OPS_VARGETTER_H

#include <libwccl/ops/functions.h>

namespace Wccl {


/**
 * Operator that returns value of a variable of given type T
 */
template<class T>
class VarGetter : public Function<T> {
public:
	VarGetter(const VariableAccesor<T>& var_acc)
		: var_acc_(var_acc)
	{
	}
	
	/**
	 * @returns Operator name for variable getter, we assume "$", although real
	 * string representation depends on given Value's var_repr function
	 */
	virtual const std::string raw_operator_name() const {
		return "$";
	}

	/**
	 * @returns String representation of the variable getter which is
	 * equal to string representation of the underlying variable.
	 */
	virtual std::string to_raw_string() const {
		return T::var_repr(var_acc_.get_name());
	}

	/**
	 * @returns String representation of the variable getter which is
	 * equal to string representation of the underlying variable.
	 */
	virtual std::string to_string(const Corpus2::Tagset&) const {
		return T::var_repr(var_acc_.get_name());
	}
protected:
	/**
	 * Return value held by the underlying variable.
	 */
	virtual BaseRetValPtr apply_internal(const FunExecContext& context) const {
		return context.variables()->get_fast(var_acc_);
	}

private:
	const VariableAccesor<T> var_acc_;
};


} /* end ns Wccl */

#endif // LIBWCCL_OPS_VARGETTER_H
