#include <libwccl/ops/toupper.h>
#include <libwccl/ops/formatters.h>

namespace Wccl {

std::string ToUpper::to_string(const Corpus2::Tagset& tagset) const
{
	return UnaryFunctionFormatter::to_string(tagset, *this, *strset_expr_);
}

std::string ToUpper::to_raw_string() const {
	return UnaryFunctionFormatter::to_raw_string(*this, *strset_expr_);
}

ToUpper::BaseRetValPtr ToUpper::apply_internal(const FunExecContext& context) const {
	const boost::shared_ptr<const StrSet >& set = strset_expr_->apply(context);
	boost::shared_ptr<StrSet > u_set = boost::make_shared<StrSet>();
	//TODO: should tolower be a method of StrSet as well?
	foreach(const UnicodeString& s, set->contents()) {
		//TODO: what about locale? is default ok? should the context hold it?
		u_set->insert(UnicodeString(s).toUpper());
	}
	return u_set;
}

} /* end ns Wccl */
