#ifndef LIBWCCL_OPS_OR_H
#define LIBWCCL_OPS_OR_H

#include <libwccl/ops/logicalpredicate.h>

namespace Wccl {

/**
 * Operator that realises logical predicate "or"
 */
class Or : public LogicalPredicate
{
public:
	Or(const boost::shared_ptr<BoolFunctionPtrVector>& expressions)
		: LogicalPredicate(expressions)
	{
	}

protected :
	/**
	 * "Or" predicate evaluates expressions one by one in order from left to right,
	 * and True is returned once an expression evaluating to True is found.
	 * If all of the expressions were False, False is returned.
	 */
	virtual BaseRetValPtr apply_internal(const FunExecContext&) const;

	virtual const std::string raw_operator_name() const;
};

} /* end ns Wccl */
#endif // LIBWCCL_OPS_OR_H
