#include <libwccl/ops/nor.h>
#include <boost/foreach.hpp>
#define foreach         BOOST_FOREACH

namespace Wccl {

Nor::BaseRetValPtr Nor::apply_internal(const FunExecContext& context) const
{
	foreach(BoolFunctionPtr expression, *expressions_) {
		if(expression->apply(context)->get_value()) {
			return Predicate::False(context);
		}
	}
	return Predicate::True(context);
}

const std::string Nor::raw_operator_name() const {
	return "not";
}

} /* end ns Wccl */
