#ifndef LIBWCCL_OPS_INTERSECTS_H
#define LIBWCCL_OPS_INTERSECTS_H

#include <libwccl/ops/setpredicate.h>

namespace Wccl {

/**
 * Class that realises a predicate checking if one set intersects with another
 */
template <class T>
class Intersects : public SetPredicate<T>
{
public:
	Intersects(const SetFunctionPtr& set1_expr, const SetFunctionPtr& set2_expr)
		: SetPredicate<T>(set1_expr, set2_expr)
	{
	}

	virtual const std::string raw_operator_name() const {
		return "inter";
	}

protected:
	/**
	 * Take values for both sets and return True if they intersect,
	 * False otherwise.
	 */
	virtual BaseRetValPtr apply_internal(const FunExecContext& context) const {
		boost::shared_ptr<T> set1 = this->set1_expr_->apply(context);
		boost::shared_ptr<T> set2 = this->set2_expr_->apply(context);
		if(set1->is_subset_of(*set2)) {
			return Predicate::True(context);
		}
		return Predicate::False(context);
	}

};

} /* end ns Wccl */


#endif // LIBWCCL_OPS_INTERSECTS_H
