#include <libwccl/ops/formatters.h>
#include <sstream>

namespace Wccl {

// ------ UnaryFunctionFormatter -----

std::string UnaryFunctionFormatter::to_raw_string(
	const FunctionBase& f,
	const FunctionBase& arg_expr,
	const char* open_bracket,
	const char* close_bracket)
{
	std::stringstream ss;
	ss << f.raw_operator_name() << open_bracket << arg_expr.to_raw_string()
		<< close_bracket;
	return ss.str();
}

std::string UnaryFunctionFormatter::to_string(
	const Corpus2::Tagset& tagset,
	const FunctionBase& f,
	const FunctionBase& arg_expr,
	const char* open_bracket,
	const char* close_bracket)
{
	std::stringstream ss;
	ss << f.operator_name(tagset) << open_bracket << arg_expr.to_string(tagset)
		<< close_bracket;
	return ss.str();
}

// ----- BinaryFunctionFormatter ------

std::string BinaryFunctionFormatter::to_string(
	const Corpus2::Tagset& tagset,
	const FunctionBase& f,
	const FunctionBase& arg1_expr,
	const FunctionBase& arg2_expr)
{
	std::stringstream ss;
	ss << f.operator_name(tagset) << "(" << arg1_expr.to_string(tagset)
		<< ", " << arg2_expr.to_string(tagset) << ")";
	return ss.str();
}

std::string BinaryFunctionFormatter::to_raw_string(
	const FunctionBase& f,
	const FunctionBase& arg1_expr,
	const FunctionBase& arg2_expr)
{
	std::stringstream ss;
	ss << f.raw_operator_name() << "(" << arg1_expr.to_raw_string()
		<< ", " << arg2_expr.to_raw_string() << ")";
	return ss.str();
}

} /* end ns Wccl */
