#include <libwccl/ops/and.h>
#include <boost/foreach.hpp>
#undef foreach
#define foreach         BOOST_FOREACH

namespace Wccl {

And::BaseRetValPtr And::apply_internal(const FunExecContext& context) const
{
	foreach(boost::shared_ptr< Function<Bool> > expression, *expressions_) {
		if(!(expression->apply(context)->get_value())) {
			return Predicate::False(context);
		}
	}
	return Predicate::True(context);
}

const std::string And::raw_operator_name() const {
	return "and";
}

} /* end ns Wccl */
