#ifndef LIBWCCL_OPS_MATCH_MATCHOPERATOR_H
#define LIBWCCL_OPS_MATCH_MATCHOPERATOR_H

#include <libwccl/ops/match/conditions/conjconditions.h>

namespace Wccl {

/**
 * Operator that realizes "match" functionality for match rules
 */
class MatchOperator : public Expression
{
public:
	MatchOperator(const boost::shared_ptr<ConjConditions>& conditions)
		: _conditions(conditions) {
		BOOST_ASSERT(_conditions);
	}

	/**
	 * @returns Name of the operator.
	 */
	std::string name() const {
		return "match";
	}

	/**
	 * @returns String representation of the Action
	 */
	std::string to_string(const Corpus2::Tagset& tagset) const;

	/**
	 * Applies the operator to the given context.
	 * @returns Vector of matches corresponding to match conditions,
	 * if all conditions were met. In such case current sentence position
	 * points to one position ahead of matched tokens.
	 * Empty MatchVector is returned if any of the conditions was not met.
	 * In such case current Position in sentence is advanced by 1.
	 * @param context Execution context - current sentence and Variables to operate on
	 */
	boost::shared_ptr<Match> apply(const ActionExecContext& context) const;

protected:
	/**
	 * Writes string representation of the operator to
	 * an output stream.
	 * @returns Stream written to.
	 * @note May be incomplete and/or containt internal info.
	 */
	std::ostream& write_to(std::ostream& ostream) const;

private:
	const boost::shared_ptr<ConjConditions> _conditions;
};

} /* end ns Wccl */

#endif // LIBWCCL_OPS_MATCH_MATCHOPERATOR_H
