#ifndef LIBWCCL_OPS_TAGACTIONS_UNMARK_H
#define LIBWCCL_OPS_TAGACTIONS_UNMARK_H

#include <libwccl/ops/tagaction.h>
#include <libwccl/values/position.h>
#include <libwccl/values/bool.h>
#include <libwccl/ops/function.h>

namespace Wccl {

/**
 * Action to unmark (delete) an annotation passing through a token.
 */
class Unmark : public TagAction
{
public:
	typedef boost::shared_ptr<Function<Position> > PosFunctionPtr;

	Unmark(
		const PosFunctionPtr& pos,
		const std::string& chan_name)
		: pos_(pos),
		  chan_name_(chan_name)
	{
		BOOST_ASSERT(pos_);
		BOOST_ASSERT(!chan_name.empty());
	}

	/**
	 * @returns Name of the function.
	 */
	std::string name() const {
		return "unmark";
	}

	/**
	 * @returns String representation of the Action
	 */
	std::string to_string(const Corpus2::Tagset& tagset) const;

protected:
	/**
	 * Writes string representation of the Action to
	 * an output stream.
	 * @returns Stream written to.
	 * @note May be incomplete and/or containt internal info.
	 */
	std::ostream& write_to(std::ostream& ostream) const;

	/**
	 * Executes the Action on given context: Marks an annotation within
	 * the given channel on the range supplied. It is an error if there
	 * already is an annotation anywhere in the range in the channel.
	 * The Range is trimmed to sentence boundaries.
	 * No action is made in case of an invalid/empty range.
	 * @returns True if there were any changes made; False otherwise
	 */
	Bool execute(const ActionExecContext &context) const;

private:
	const PosFunctionPtr pos_;
	const std::string chan_name_;
};

} /* end ns Wccl */

#endif // LIBWCCL_OPS_TAGACTIONS_UNMARK_H
