#ifndef LIBWCCL_OPS_TAGACTIONS_DELETE_H
#define LIBWCCL_OPS_TAGACTIONS_DELETE_H

#include <libwccl/ops/tagaction.h>
#include <libwccl/values/position.h>
#include <libwccl/values/bool.h>
#include <libwccl/ops/function.h>

namespace Wccl {

/**
 * Action to delete lexemes that meet a condition
 * (unless no lexemes would be left, in which case
 * token is left alone with no changes)
 */
class Delete : public TagAction
{
public:
	typedef boost::shared_ptr<Function<Position> > PosFunctionPtr;
	typedef boost::shared_ptr<Function<Bool> > BoolFunctionPtr;

	Delete(const BoolFunctionPtr& condition, const PosFunctionPtr& pos = detail::CurrentPos())
		: pos_(pos),
		  condition_(condition)
	{
		BOOST_ASSERT(pos_);
		BOOST_ASSERT(condition_);
	}

	/**
	 * @returns Name of the function.
	 */
	std::string name() const {
		return "delete";
	}

	/**
	 * @returns String representation of the Action
	 */
	std::string to_string(const Corpus2::Tagset& tagset) const;

	/**
	 * Executes the Action on given context: it deletes
	 * all lexemes of the token at given position that meet
	 * the condition, unless all of them meet the condition.
	 * In such case no action is commited to avoid a token
	 * that would otherwise have no lexemes remaining.
	 * Also, no action is done if position points outside sentence.
	 * @returns True if there were any changes made; False otherwise
	 */
	Bool execute(const ActionExecContext &context) const;

protected:
	/**
	 * Writes string representation of the Action to
	 * an output stream.
	 * @returns Stream written to.
	 * @note May be incomplete and/or containt internal info.
	 */
	std::ostream& write_to(std::ostream& ostream) const;

private:
	const PosFunctionPtr pos_;
	const BoolFunctionPtr condition_;
};

} /* end ns Wccl */

#endif // LIBWCCL_OPS_TAGACTIONS_DELETE_H
