#include <libwccl/ops/functions/strset/getlemmas.h>
#include <libwccl/ops/formatters.h>
#include <libwccl/ops/functions/constant.h>

namespace Wccl {

std::string GetLemmas::to_string(const Corpus2::Tagset& tagset) const
{
	return UnaryFunctionFormatter::to_string(tagset, *this, *pos_expr_, "[", "]");
}

std::ostream& GetLemmas::write_to(std::ostream& os) const
{
	return os << raw_name() << "[" << *pos_expr_ << "]";
}

GetLemmas::BaseRetValPtr GetLemmas::apply_internal(const FunExecContext& context) const
{
	const boost::shared_ptr<const Position>& pos = pos_expr_->apply(context);
	const SentenceContext& sc = context.sentence_context();
	if (sc.is_outside(*pos)) {
		return detail::DefaultFunction<StrSet>()->apply(context);
	}
	boost::shared_ptr<StrSet> u_set = boost::make_shared<StrSet>();
	foreach(const Corpus2::Lexeme& lexeme, sc.at(*pos)->lexemes()) {
		u_set->insert(lexeme.lemma());
	}
	return u_set;
}

} /* end ns Wccl */
